/*--------------------- Copyright (c) 2020 -----------------------
[Master Javascript]
Project: Multifarious Services - Responsive HTML Template 
Version: 1.0.0
Assigned to: Theme Forest
-------------------------------------------------------------------*/
(function ($) {
	"use strict";
	/*-----------------------------------------------------
		Function  Start
	-----------------------------------------------------*/
		var Multifarious = {
			initialised: false,
			version:1.0,
			mobile: false,
			init: function () {
				if (!this.initialised) {
					this.initialised = true;
				} else {
					return;
				}
				/*-----------------------------------------------------
					Function Calling
				-----------------------------------------------------*/
				this.preLoader();
				this.wowAnimation();
				this.navMenu();
				this.focusText();
				this.partner();
				this.topButton();
				this.waTestimonial();
				this.waPartner();
				this.isotop_gallery();
				this.wa_mpa();
				this.popupGallery();
				this.ScrollTop();
			},

			/*-----------------------------------------------------
	         Fixed Header
	        -----------------------------------------------------*/
	        ScrollTop: function(){
	                if($('.fixed_header').length > 0){
	                    $(window).scroll(function() {  
	                    var scroll = $(window).scrollTop();

	                    if (scroll >= 100) {
	                    $(".fixed_header").addClass("fixed");
	                    }
	                    else
	                    {
	                      $(".fixed_header").removeClass("fixed");
	                    }
	                  
	                  });
	                }
	              },
			/*-----------------------------------------------------
				Fix Preloader
			-----------------------------------------------------*/
			preLoader: function () {
				$(window).on('load', function () {
					$(".preloader_wrapper").removeClass('preloader_active');
				});
				jQuery(window).on('load', function () {
					setTimeout(function () {
						jQuery('.preloader_open').addClass('loaded');
					}, 100);
				});
			},

			/*-----------------------------------------------------
				Fix Gallery Magnific Popup
			-----------------------------------------------------*/
			popupGallery: function () {
				jQuery(document).ready(function(){
					$('.popup_gallery4').magnificPopup({
						delegate: 'a',
						type: 'image',
						tLoading: 'Loading image #%curr%...',
						mainClass: 'mfp-img-mobile',
						gallery: {
							enabled: true,
							navigateByImgClick: true,
							preload: [0,1] // Will preload 0 - before current, and 1 after the current image
						},
						image: {
							tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
							titleSrc: function(item) {
								return item.el.attr('title') + '<small></small>';
							}
						}
					});
				});
			},
			/*-----------------------------------------------------
				Fix Animation 
			-----------------------------------------------------*/
			wowAnimation: function () {
				new WOW().init();
			},

			/*-----------------------------------------------------
				Fix Mobile Menu 
			-----------------------------------------------------*/
			navMenu: function () {
				var w = window.innerWidth;
				if (w <= 991) {
					$(".main_menu_wrapper>ul li").on('click', function () {
						$(this).find('ul.sub_menu').slideToggle();
						$(this).toggleClass("open");
					});
					$(".main_menu_wrapper>ul").on('click', function () {
						event.stopPropagation();
					});
					$(".menu_btn").on('click', function (e) {
						event.stopPropagation();
						$(".main_menu_wrapper, .menu_btn_wrap").toggleClass("open");
					});
					$("body").on('click', function () {
						$(".main_menu_wrapper, .menu_btn_wrap").removeClass("open");
					});
				}
			},

			/*-----------------------------------------------------
				Fix  On focus Placeholder
			-----------------------------------------------------*/
			focusText: function () {
				var place = '';
				$('input,textarea').focus(function () {
					place = $(this).attr('placeholder');
					$(this).attr('placeholder', '');
				}).blur(function () {
					$(this).attr('placeholder', place);
				});
			},

			/*-----------------------------------------------------
				Fix Partner Slider 
			-----------------------------------------------------*/
			partner: function () {
				var PartnerSwiper = new Swiper('.partner_slider.swiper-container', {
					autoHeight: false,
					autoplay: true,
					spaceBetween: 30,
					slidesPerView: 8,
					loop: true,
					speed: 2000,
					autoplay: {
						delay: 1000,
					},
					breakpoints: {
						0: {
							slidesPerView: 2,
							spaceBetween: 0,
						},
						575: {
							slidesPerView: 2,
							spaceBetween: 10,
						},
						767: {
							slidesPerView: 4,
							spaceBetween: 20,
						},
						992: {
							slidesPerView: 6,
							spaceBetween: 20,
						},
						1200: {
							slidesPerView: 6,
							spaceBetween: 30,
						},
					},
				});
			},

			/*-----------------------------------------------------
				Fix GoToTopButton
			-----------------------------------------------------*/
			topButton: function () {
				var scrollTop = $("#scroll");
				$(window).on('scroll', function () {
					if ($(this).scrollTop() < 500) {
						scrollTop.removeClass("active");
					} else {
						scrollTop.addClass("active");
					}
				});
				$('#scroll').click(function () {
					$("html, body").animate({
						scrollTop: 0
					}, 2000);
					return false;
				});

				$(function() {
					$('.go_to_demo').click (function() {
						$('html, body').animate({scrollTop: $('#go_to_demo').offset().top }, 'slow');
						return false;
					});
				});
			},
			
			/*-----------------------------------------------------
				web agency Testimonial Slider 
			-----------------------------------------------------*/
			waTestimonial: function () {
				var TestimonialSwiper = new Swiper('.wa_testimonial_slider .swiper-container.s2', {
					autoHeight: false,
					autoplay: false,
					loop: true,
					spaceBetween: 0,
					centeredSlides: false,
					speed: 1500,
					autoplay: {
						delay: 8000,
					},
					navigation: {
						nextEl: '.wa_Testimonial_wrapper .wa_test_next',
						prevEl: '.wa_Testimonial_wrapper .wa_test_prev',
					},
				});
			},
			/*-----------------------------------------------------
				Web agency Partner Slider 
			-----------------------------------------------------*/
			waPartner: function () {
				var partnersSwiper = new Swiper('.wa_partner_wrapper .swiper-container', {
					autoHeight: false,
					autoplay: true,
					spaceBetween: 60,
					slidesPerView: 4,
					loop: true,
					speed: 1500,
					autoplay: {
						delay: 1000,
					},
					navigation: {
						nextEl: '.wa_partner_wrapper .wa_test_next',
						prevEl: '.wa_partner_wrapper .wa_test_prev',
					},
					breakpoints: {
						0: {
							slidesPerView: 1,
							spaceBetween: 0,
						},
						575: {
							slidesPerView: 1,
							spaceBetween: 10,
						},
						767: {
							slidesPerView: 2,
							spaceBetween: 20,
						},
						992: {
							slidesPerView: 3,
							spaceBetween: 20,
						},
						1200: {
							slidesPerView: 4,
							spaceBetween: 30,
						},
					},
				});
			},
			/*-----------------------------------------------------
				Web agency isotop gallery
			-----------------------------------------------------*/
			isotop_gallery: function() {
				if($('.gallery_grid').length > 0){
					$('.gallery_grid').isotope({
							itemSelector: '.grid-item',
							filter: '*'
						});
						$('.wa_project_gallery > .gallery_nav > ul > li').on( 'click', 'a', function() {
							// filter button click
							var filterValue = $( this ).attr('data-filter');
							$('.gallery_grid').isotope({ filter: filterValue });
	
							//active class added
							$('a').removeClass('gallery_active');
							$(this).addClass('gallery_active');
						});
				}
			},
			/*-----------------------------------------------------
				Web agency map
			-----------------------------------------------------*/
			wa_mpa: function() {
				if($('#world-map').length > 0){
					$(function(){
						$('#world-map').vectorMap({
						map: 'world_mill',
						scaleColors: ['#C8EEFF', '#0071A4'],
						normalizeFunction: 'polynomial',
						hoverOpacity: 0.9,
						hoverColor: false,
						zoomOnScrollSpeed:1, //default value is 3
						zoomStep:1.1, //default value is 1.6
							markerStyle: {
											initial:{
														fill: 'rgb(255, 246, 227)',
														stroke: '#ffae0d'
													},
											hover: {
														stroke: '#ffae0d',
														fill:'#ffae0d',
														"stroke-width": 2,
														cursor: 'pointer'
													},
											selected:{
														fill: 'blue'
													},
											selectedHover: {
															}
										},
							regionStyle:{
											initial: {
														fill: '#e3eaef',
														"fill-opacity": 1,
														stroke: 'none',
														"stroke-width": 0,
														"stroke-opacity": 1
													},
											hover: {
														"fill-opacity": 0.8,
														cursor: 'pointer'
													},
											selected:{
														fill: 'yellow'
													},
											selectedHover: {
															}
										},
							backgroundColor: '#rgb(255 255 255 / 0%)',
							markers: [
								{
									latLng: [31.230391, 121.473701],
									name: 'Shanghai',
								},
								{
									latLng: [39.904202, 116.407394],
									name: 'Beijing',
								},
								{
									latLng: [28.70406, 77.102493],
									name: 'Delhi',
								},
								{
									latLng: [6.524379, 3.379206],
									name: 'Lagos',
								},
								{
									latLng: [39.343357, 117.361649],
									name: 'Tianjin',
								},
								{
									latLng: [24.860735, 67.001137],
									name: 'Karachi',
								},
								{
									latLng: [41.00824, 28.978359],
									name: 'Istanbul',
								},
								{
									latLng: [35.689487, 139.691711],
									name: 'Tokyo',
								},
								{
									latLng: [23.12911, 113.264381],
									name: 'Guangzhou',
								},
								{
									latLng: [19.075983, 72.877655],
									name: 'Mumbai',
								},
								{
									latLng: [40.7127837, -74.0059413],
									name: 'New York',
								},
								{
									latLng: [34.052235, -118.243683],
									name: 'Los Angeles',
								},
								{
									latLng: [41.878113, -87.629799],
									name: 'Chicago',
								},
								{
									latLng: [29.760427, -95.369804],
									name: 'Houston',
								},
								{
									latLng: [33.448376, -112.074036],
									name: 'Phoenix',
								},
								{
									latLng: [51.507351, -0.127758],
									name: 'London',
								},
								{
									latLng: [48.856613, 2.352222],
									name: 'Paris',
								},
								{
									latLng: [55.755825, 37.617298],
									name: 'Moscow',
								},
								{
									latLng: [40.416775, -3.70379],
									name: 'Madrid',
								},
							]
						});
						});
				}
			},			


		};

		Multifarious.init();

})(jQuery);

/*-----------------------------------------------------
	Fix Contact Form Submission
-----------------------------------------------------*/
// Contact Form Submission
function checkRequire(formId , targetResp){
    targetResp.html('');
    var email = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/;
    var url = /(http|ftp|https):\/\/[\w-]+(\.[\w-]+)+([\w.,@?^=%&amp;:\/~+#-]*[\w@?^=%&amp;\/~+#-])?/;
    var image = /\.(jpe?g|gif|png|PNG|JPE?G)$/;
    var mobile = /^[\s()+-]*([0-9][\s()+-]*){6,20}$/;
    var facebook = /^(https?:\/\/)?(www\.)?facebook.com\/[a-zA-Z0-9(\.\?)?]/;
    var twitter = /^(https?:\/\/)?(www\.)?twitter.com\/[a-zA-Z0-9(\.\?)?]/;
    var google_plus = /^(https?:\/\/)?(www\.)?plus.google.com\/[a-zA-Z0-9(\.\?)?]/;
    var check = 0;
    $('#er_msg').remove();
    var target = (typeof formId == 'object')? $(formId):$('#'+formId);
    target.find('input , textarea , select').each(function(){
        if($(this).hasClass('require')){
            if($(this).val().trim() == ''){
                check = 1;
                $(this).focus();
                $(this).parent('div').addClass('form_error');
                targetResp.html('You missed out some fields.');
                $(this).addClass('error');
                return false;
            }else{
                $(this).removeClass('error');
                $(this).parent('div').removeClass('form_error');
            }
        }
        if($(this).val().trim() != ''){
            var valid = $(this).attr('data-valid');
            if(typeof valid != 'undefined'){
                if(!eval(valid).test($(this).val().trim())){
                    $(this).addClass('error');
                    $(this).focus();
                    check = 1;
                    targetResp.html($(this).attr('data-error'));
                    return false;
                }else{
                    $(this).removeClass('error');
                }
            }
        }
    });
    return check;
}
$(".submitForm").on('click', function() {
    var _this = $(this);
    var targetForm = _this.closest('form');
    var errroTarget = targetForm.find('.response');
    var check = checkRequire(targetForm , errroTarget);
    
    if(check == 0){
       var formDetail = new FormData(targetForm[0]);
        formDetail.append('form_type' , _this.attr('form-type'));
        $.ajax({
            method : 'post',
            url : 'ajaxmail.php',
            data:formDetail,
            cache:false,
            contentType: false,
            processData: false
        }).done(function(resp){
            console.log(resp);
            if(resp == 1){
                targetForm.find('input').val('');
                targetForm.find('textarea').val('');
                errroTarget.html('<p style="color:green;">Mail has been sent successfully.</p>');
            }else{
                errroTarget.html('<p style="color:red;">Something went wrong please try again latter.</p>');
            }
        });
    }
});
